﻿var selectStrata = {
    context: $(".v-selectStrata"),
    projectListView: null,
    strataDataTable: null,
    currentProjectId: 0,
    selectedStratas: [],
    initialize: function () {
        selectStrata.projectListView = $(".h-projects", selectStrata.context).a4listview({
            ajaxAction: a4.getProjectAction("GetStrataProjects", "Home"),
            draw: function (event, data) {
                var project = data.selectedNode;
                var projectId = project ? project.Id : null;

                if (projectId != null && selectStrata.strataDataTable == null) {
                    selectStrata.initializeStrataDataTable(projectId);
                }
            },
            actionButtons: [
                { Action: "select", Label: resources.Select, Icon: "checkbox-unchecked", DisplayCondition: function (data) { return selectStrata.isProjectChecked(data.Id, data.HasStrata) == false; } },
                { Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked", DisplayCondition: function (data) { return selectStrata.isProjectChecked(data.Id, data.HasStrata); } }
            ],
            displayActionButtonsOnLeft: true,
            displayActionButtonsOnHover: false,
            highlightFirstNode: true,
            icons: null,
            selectNode: function (event, data) {
                var projectId = data.node ? data.node.Id : null;
                selectStrata.currentProjectId = projectId || 0;

                if (typeof projectId !== "undefined") {
                    if (selectStrata.strataDataTable) {
                        selectStrata.strataDataTable.a4datatable("option", "ajaxParams", { "projectId": projectId, "selectedRows": JSON.stringify(selectStrata.getSelectedStratas()) });
                        selectStrata.strataDataTable.a4datatable("refresh", false);
                    }
                    else {
                        selectStrata.initializeStrataDataTable(projectId);
                    }
                }

                selectStrata.projectListView.a4listview("evaluateActionsConditions", projectId);
            },
            localizableTexts: { "Search": resources.SearchProjects }
        });
    },
    isProjectChecked: function (projectId, hasStrata) {
        var index = _.findIndex(selectStrata.selectedStratas, { ProjectId: projectId });
        return index > -1 ? selectStrata.selectedStratas[index].Quotas.length > 0 : hasStrata;
    },
    initializeStrataDataTable: function (projectId) {
        selectStrata.currentProjectId = projectId;
        selectStrata.strataDataTable = $(".h-strata", selectStrata.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetProjectStrata", "Home", "Project"),
            ajaxParams: { "projectId": projectId, "selectedRows": JSON.stringify(selectStrata.getSelectedStratas()) },
            displayLength: 10,
            allowRowSelection: true,
            displayColumnSelector: false,
            selectedRowsExpression: "[IsOnDashboard]",
            columns: [
                { "Data": "Position", "Title": resources.Stratum, "Type": "numeric" },
                { "Data": "Criterion", "Title": resources.Criterion },
                { "Data": "Label", "Title": resources.Label }
            ],
            defaultSorting: "Position",
            selectRow: function (e, d) {
                if (d.data != null && d.data.length > 0) {
                    var selectedItems = d.data;

                    if (selectedItems != null && selectedItems.length > 0) {
                        selectStrata.updateSelectedStratas({ ProjectId: selectStrata.currentProjectId, Quotas: _.pluck(selectedItems, "Position"), isModified: false }, d.isChecked);
                    }

                    selectStrata.projectListView.a4listview("evaluateActionsConditions");
                }
            },
            localizableTexts: { "Search": resources.SearchStrata }
        });

    },
    getSelectedStratas: function () {
        var strata = selectStrata.selectedStratas.filter(function (item) {
            return item.ProjectId == selectStrata.currentProjectId;
        });

        return strata[0] != null ? strata[0].Quotas : "";
    },
    updateSelectedStratas: function (item, isAdding) {
        var index = _.findIndex(selectStrata.selectedStratas, { ProjectId: item.ProjectId });

        if (index > -1) {
            if (isAdding) {
                selectStrata.selectedStratas[index].Quotas = _.union(selectStrata.selectedStratas[index].Quotas, item.Quotas);
            }
            else {
                selectStrata.selectedStratas[index].Quotas = _.difference(selectStrata.selectedStratas[index].Quotas, item.Quotas);
            }
        }
        else {
            selectStrata.selectedStratas.push(item);
        }
    },
    bindEvents: function () {
        selectStrata.context.on("click", ".v-buttonSave", function () {
            a4.callServerMethod(a4.getProjectAction("SaveProjectStrata", "Home"), { projectStratas: JSON.stringify(selectStrata.selectedStratas) },
            function (result) {
                if (!result.success) {
                    a4.showErrorMessage(result.message);
                }
                else {
                    modalDialog.close();
                }
            });
        });
    }
}

$(document).ready(function () {
    if (selectStrata.context.length > 0) {
        selectStrata.initialize();
        selectStrata.bindEvents();
    }
});